/* Function 9-1 from Chapter 9
   of "Scatter Search" by M. Laguna & R. Marti */

#include "ocl.h"
#include <stdio.h>
#include <stdlib.h>
 
int n_var(int nproblem, char *fname, double *lower,double *upper,double *opt);
double evaluate(int nproblem, int nvar, double *x);

int main(int argc, char **argv)
{
	double  objval, x[100];
	long    nprob, nsol;
	int     i, prob, nvar, TotalIter;
	double  lower, upper, optval, pval;
	char    fname[50];

	if (argc != 4) 
	{
		printf("usage: oclmain <iter> <prob> <aggressive>\n");
		exit(1);
	}
	TotalIter = atoi(argv[1]);
	prob = atoi(argv[2]);
	pval = atof(argv[3]);

	nvar = n_var(prob,fname,&lower,&upper,&optval);
	nprob = OCLSetup(nvar,0,0,0,"MIN",999999999);
	if (nprob < 0) exit(1);
	for(i=1;i<=nvar;i++)
	OCLDefineVar(nprob,i,lower,OCLGetNull(nprob),upper,"CON",1);
	OCLSetSearchStrategies(nprob,"aggressive",pval);
	OCLInitPop(nprob);
	for (i = 1; i <= TotalIter; i++)
	{
		nsol=OCLGetSolution(nprob,x);
		objval = evaluate(prob,nvar,x);
		OCLPutSolution(nprob,nsol,&objval,(double *)OCLGetNull(nprob));
		if(!(i%100))
		{
			OCLGetBest(nprob,x,&objval);
			printf("Iter: %6d  Best ObjVal: %15.6lf\n",i,objval);
		}
	}
	OCLGoodBye(nprob);
	return 0;
}